// Rocko's AOE Dragon.
using System;
using Server;
using Server.Items;
using Xanthos.Evo;

namespace Server.Mobiles
{
    public enum DaemonAbilities {
      ArmorIgrnore,
      ArmorPierce,
      BladeWeave,
      BleedAttack,
      Block,
      ConcussionBlow,
      CrushingBlow,
      DefenseMastery,
      Disarm,
      Dismount,
      DoubleShot,
      DoubleStrike,
      DualWield,
      Feint,
      ForceArrow,
      ForceofNature,
      FrenziedWhirlwind,
      InfectiousStrike,
      LightningArrow,
      MortalStrike,
      MovingShot,
      NerveStrike,
      ParalyzingBlow,
      PsychicAttack,
      RidingSwipe,
      SerpentArrow,
      ShadowStrike,
      TalonStrike,
      WhirlwindAttack
    }

    public class AoEDaemon : BaseCreature
    {
        private bool m_Breath;
        private int m_Range;
        private int m_Damage;
        private int m_Duration;
        private int m_Hue;
        private int m_EffectId;
        private double m_AbilityChance;
        private DaemonAbilities m_Ability;
        
      [CommandProperty( AccessLevel.GameMaster )]
  		public bool UseBreath
  		{
  			get { return m_Breath; }
  			set { m_Breath = value; }
  		}
  		
      [CommandProperty( AccessLevel.GameMaster )]
  		public int BreathRange
  		{
  			get { return m_Range; }
  			set { 
          if ( value < 0 )
            m_Range = 0;
          else if ( value > 30 )
            m_Range = 30;
          else              
            m_Range = value;
        }
  		}
        
      [CommandProperty( AccessLevel.GameMaster )]
  		public int BreathDamage
  		{
  			get { return m_Damage; }
  			set { 
          if ( value < 0 )
            m_Damage = 0;
          else if ( value > 800 )
            m_Damage = 800;
          else              
            m_Damage = value;
        }
  		}
        
      [CommandProperty( AccessLevel.GameMaster )]
  		public int BreathDuration
  		{
  			get { return m_Duration; }
  			set { 
          if ( value < 0 )
            m_Duration = 0;
          else if ( value > 30 )
            m_Duration = 30;
          else              
            m_Duration = value;
        }
  		}   
        
      [CommandProperty( AccessLevel.GameMaster )]
  		public int BreathHue
  		{
  			get { return m_Hue; }
  			set { 
          m_Hue = value;
          
          if ( m_Hue < 0 )
            m_Hue = 0;
        }
  		}
  		
      [CommandProperty( AccessLevel.GameMaster )]
  		public int BreathEffectId
  		{
  			get { return m_EffectId; }
  			set { 
          m_EffectId = value;
          
          if ( m_EffectId <= 0 )
            m_EffectId = 14089; // fire column
        }
  		}
  		
      [CommandProperty( AccessLevel.GameMaster )]
  		public double AbilityChance
  		{
  			get { return m_AbilityChance; }
  			set { 
          m_AbilityChance = value;
          
          if ( m_AbilityChance < 0 || m_AbilityChance == null )
            m_AbilityChance = 0.0001;
          else if ( m_AbilityChance > 1.0 )
            m_AbilityChance = 1.0;
        }
  		}
  		
      [CommandProperty( AccessLevel.GameMaster )]
  		public DaemonAbilities DaemonAbility
  		{
  			get { return m_Ability; }
  			set { m_Ability = value; }
  		}
         
        public override double WeaponAbilityChance { get { return m_AbilityChance; } }
        
        public override WeaponAbility GetWeaponAbility()
        {
            if ( m_Ability != null ) {
              switch ( (int)m_Ability ) {
                case 0: return WeaponAbility.ArmorIgnore; break;
                case 1: return WeaponAbility.ArmorPierce; break;
                case 2: return WeaponAbility.Bladeweave; break;
                case 3: return WeaponAbility.BleedAttack; break;
                case 4: return WeaponAbility.Block; break;
                case 5: return WeaponAbility.ConcussionBlow; break;
                case 6: return WeaponAbility.CrushingBlow; break;
                case 7: return WeaponAbility.DefenseMastery; break;
                case 8: return WeaponAbility.Disarm; break;
                case 9: return WeaponAbility.Dismount; break;
                case 10: return WeaponAbility.DoubleShot; break;
                case 11: return WeaponAbility.DoubleStrike; break;
                case 12: return WeaponAbility.DualWield; break;
                case 13: return WeaponAbility.Feint; break;
                case 14: return WeaponAbility.ForceArrow; break;
                case 15: return WeaponAbility.ForceOfNature; break;
                case 16: return WeaponAbility.FrenziedWhirlwind; break;
                case 17: return WeaponAbility.InfectiousStrike; break;
                case 18: return WeaponAbility.LightningArrow; break;
                case 19: return WeaponAbility.MortalStrike; break;
                case 20: return WeaponAbility.MovingShot; break;
                case 21: return WeaponAbility.NerveStrike; break;
                case 22: return WeaponAbility.ParalyzingBlow; break;
                case 23: return WeaponAbility.RidingSwipe; break;
                case 24: return WeaponAbility.SerpentArrow; break;
                case 25: return WeaponAbility.ShadowStrike; break;
                case 26: return WeaponAbility.TalonStrike; break;
                case 27: return WeaponAbility.WhirlwindAttack; break;
                default: return WeaponAbility.ArmorIgnore; break;
              }
            }
            else
              return WeaponAbility.ParalyzingBlow;
        }

        [Constructable]
        public AoEDaemon()
            : base(AIType.AI_Melee, FightMode.Strongest, 10, 1, 0.2, 0.4)
        {
            Name = "Underworld daemon";
            Body = 303; // devourer
            BaseSoundID = 357;
            Hue = 61;

            SetStr(784, 840);
            SetDex(248, 450);
            SetInt(604, 975);

            SetHits(1300, 2000);
            SetStam(700, 900);

            SetDamage(40, 56);
                                                
            SetDamageType(ResistanceType.Physical, 40);
            SetDamageType(ResistanceType.Fire, 40);
            SetDamageType(ResistanceType.Energy, 40);
            SetDamageType(ResistanceType.Poison, 40);
            SetDamageType(ResistanceType.Cold, 40);

            SetResistance(ResistanceType.Physical, 50);
            SetResistance(ResistanceType.Fire, 70);
            SetResistance(ResistanceType.Cold, 50);
            SetResistance(ResistanceType.Poison, 50);
            SetResistance(ResistanceType.Energy, 70);

            SetSkill(SkillName.EvalInt, 190.0, 220.0);
            SetSkill(SkillName.Magery, 190.0, 220.0);
            SetSkill(SkillName.Meditation, 30.0, 60.0);
            SetSkill(SkillName.MagicResist, 150.5, 200.0);
            SetSkill(SkillName.Tactics, 100.0, 110.0);
            SetSkill(SkillName.Wrestling, 130.0, 140.0);
            SetSkill(SkillName.Bushido, 100.0, 105.0);
            SetSkill(SkillName.Ninjitsu, 100.0, 105.0);

            Fame = 5000;
            Karma = -10000;

            VirtualArmor = 70;
            Tamable = false;
            AddItem(new LightSource());

            PackItem(new RaelisDemonioDust(Utility.RandomMinMax(5, 20)));
            PackItem(new Tokens(Utility.RandomMinMax(5, 10)));
            
            m_Breath = true;
            m_Range = 3;
            m_Damage = 100;
            m_Hue = 61;        
            m_Duration = 4;
            m_EffectId = 14089; 
            m_AbilityChance = 0.10; // 10% na abilitu
        }
        
        public override void OnDeath( Container c )
        {
        	base.OnDeath( c );			
        	PackRunicTool( c, 0.05, typeof( RunicDr ) );
        }

        public override void GenerateLoot()
        {
            AddLoot(LootPack.UltraRich, 3);
            AddLoot(LootPack.Gems, 8);
        }

        public override void AlterSpellDamageFrom(Mobile from, ref int damage)
        {
            damage /= 2;
        }

        public override bool BardImmune { get { return true; } }
        public override bool Unprovokable { get { return true; } }
        public override bool Uncalmable { get { return true; } }
        public override Poison PoisonImmune { get { return Poison.Greater; } }

        public override int BreathFireDamage { get { return m_Damage; } }
        public override double BreathDamageScalar { get { return 0.10; } }     

        public override bool HasAOEBreath { get { return false/*m_Breath*/; } }
        public override string AOEBreathName { get { return "dark power"; } }
        public override int AOEBreathRadius { get { return m_Range; } }
        public override int AOEBreathDuration { get { return m_Duration; } }
        public override int AOEBreathEffectItemID { get { return m_EffectId; } }
        public override int AOEBreathEffectHue { get { return m_Hue; } }

        public override bool ReacquireOnMovement { get { return true; } }
        public override bool HasBreath { get { return true; } } // breath enabled
        public override bool AutoDispel { get { return true; } }
        public override int TreasureMapLevel { get { return Utility.RandomMinMax( 6, 8 ); } }
        public override int Meat { get { return 25; } }
        public override int Hides { get { return 15; } }
        public override HideType HideType { get { return HideType.Daemon; } }
        public override int Scales { get { return 5; } }
        public override ScaleType ScaleType { get { return ScaleType.Red; } }
        public override bool IsNotScaredOfDeath { get { return true; } } //neutika pri malem poctu hp

        public AoEDaemon(Serial serial)
            : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);
            writer.Write((int)2);
            
            writer.Write( m_Breath );
            writer.Write( m_Range );
            writer.Write( m_Damage );
            writer.Write( m_Duration );
            writer.Write( m_Hue );
            writer.Write( m_EffectId );
            writer.Write( m_AbilityChance );
            writer.Write( (int)m_Ability );
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);
            int version = reader.ReadInt();
            
            switch ( version ) {
              case 0: {
                m_Range = reader.ReadInt();
                m_Damage = reader.ReadInt();
                m_Duration = reader.ReadInt();
                m_Hue = reader.ReadInt();
                m_EffectId = reader.ReadInt();
                break;
              }
              case 1: {
                m_Breath = reader.ReadBool();
                m_AbilityChance = reader.ReadDouble();
                goto case 0;
              }
              case 2: {
                m_Ability = (DaemonAbilities)reader.ReadInt();
                goto case 1;
              }
            }
        }
    }
}